-- DMS-Schema



-- ##################################### DMS-FUNKTIONEN! (Dokumente aus picndoku laden)
  -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Picndoku
  -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Entwicklerdokumentation_-_PostgreSQL
  -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Sonderfelder_im_SQL

  --Prüfung, ob ein Dokument zur dbrid existiert // FA DMS_get_dok_exists
  CREATE OR REPLACE FUNCTION TDMS.Dokument__exists__by__dbrid(
    --_taname -- Wurst, da dbrid eineindeutig
    IN _dbrid varchar
    )
    RETURNS boolean
    AS $$

      -- TODO 18.02.2019 : SELECT durch neue Funktion ersetzen, damit Suche das selbe Ergebnis liefert, wie die Objektablage anzeigt.  https://redmine.prodat-sql.de/issues/9305
      --                   Diese Funktion hier beachtet z.B. keine verlinkten Dokumente, welcher aber in der Objektablage angezeigt werden.
      -- SELECT EXISTS(TDMS.picndoku__dokuments__fetch_latest(NULL, $1));
      SELECT EXISTS(
          SELECT true
            FROM picndoku
           WHERE pd_dbrid = _dbrid
             AND NOT pd_deletable
      );

    $$ LANGUAGE sql STABLE;



  CREATE OR REPLACE FUNCTION TDMS.Dokument__picndoku_records__by__dbrid(
    --_taname -- Wurst, da dbrid eineindeutig
    IN _dbrid varchar
    )
    RETURNS SETOF picndoku
    AS $$

      SELECT *
        FROM picndoku
       WHERE pd_dbrid = _dbrid
         AND NOT pd_deletable
      ;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;
  --

  CREATE OR REPLACE FUNCTION TDMS.Dokument__exists__by__keyword(
    IN _kategorie varchar,
    IN _descr varchar
    )
    RETURNS boolean
    AS $$

      -- TODO 18.02.2019 : SELECT durch neue Funktion ersetzen, damit Suche das selbe Ergebnis liefert, wie die Objektablage anzeigt.  https://redmine.prodat-sql.de/issues/9305
      --                   Zeigt z.B. Dokumente, welche durch Limitbegrenzungen in der Objektablage nicht mehr gefunden werden können.
      SELECT EXISTS(
          SELECT true
            FROM recnokeyword JOIN picndoku ON picndoku.dbrid = r_dbrid 
                                           AND NOT pd_deletable
           WHERE r_kategorie = _kategorie
             AND r_descr = _descr
             AND r_tablename = 'picndoku'
      );

    $$ LANGUAGE sql STABLE;


  CREATE TYPE tdms.dokument__kategorie__descr AS (
      kategorie text,
      description text
  );

  -- #21986 Das Fehlen dieses Indexes verursachte bei LOLL lange WEB-Ladezeiten
  CREATE INDEX recnokeyword__tdms_dokument__kategorie__descr__filter
    ON recnokeyword( (( r_kategorie, r_descr )::tdms.dokument__kategorie__descr) )
  WHERE r_tablename = 'picndoku';


  -- Alle Dokumente zu Schlagwort zurückgeben mit speziellem Dokumenttyp
   -- aktuell 1 Dokumenttyp, siehe Code für eventuelle Ansätze zur Erweiterung
   -- SELECT * FROM TDMS.Dokument__pd_ids__by__keyword__get('art', '051-0006_04', 'we_messprot')
  CREATE OR REPLACE FUNCTION tdms.dokument__pd_ids__by__keyword_list(
    IN  _filter  tdms.dokument__kategorie__descr[],
    IN  _doktype varchar = null,

    OUT pdid        integer,
    OUT doktype     varchar,
    OUT parentid    varchar
    )
    RETURNS SETOF record
    AS $$

        WITH
          _keywords AS (
              SELECT r_dbrid
                FROM recnokeyword
               WHERE r_tablename = 'picndoku'
                 AND ( r_kategorie, r_descr )::tdms.dokument__kategorie__descr = any( _filter )
               GROUP BY r_dbrid
               HAVING array_agg( ( ( r_kategorie, r_descr )::tdms.dokument__kategorie__descr  ) )
                   @> _filter
          ),

          _documents AS (

              SELECT pd_id, pd_doktype,
                     -- entweder direkt in einen ordner geschoben, oder
                     -- automatisch eingeordnet Rückgabe des Übergeordneten
                     -- Baumknotens um in einer Liste anzeigen zu können,
                     -- wo / in welchem Ordner das Dokument liegt (Einkauf, QS etc)
                     coalesce( pd_parentnodeident, dt_parentnodeid ) AS parentfolderid
                FROM _keywords
                JOIN picndoku ON picndoku.dbrid = _keywords.r_dbrid
                             AND NOT pd_deletable                
                LEFT JOIN dokutypes ON dt_id = pd_doktype
               WHERE (   _doktype IS NULL
                      OR pd_doktype = _doktype
                      )
          )

          SELECT * FROM _documents;

    $$ LANGUAGE sql STABLE;

  CREATE OR REPLACE FUNCTION tdms.dokument__pd_ids__by__keyword(
    IN  _kategorie  varchar,
    IN  _descr      varchar,
    IN  _doktype    varchar = null,

    OUT pdid        integer,
    OUT doktype     varchar,
    OUT parentid    varchar
    )
    RETURNS SETOF record
    AS $$

        SELECT *
          FROM tdms.dokument__pd_ids__by__keyword_list(
                   array[ ( _kategorie, _descr ) ]::tdms.dokument__kategorie__descr[],
                   _doktype
               )
        ;
    $$ LANGUAGE sql STABLE;

  CREATE INDEX ON recnokeyword ( ( ( r_kategorie, r_descr )::tdms.dokument__kategorie__descr  ) );
  --

  -- > RENAME?: TDMS.Dokument__pd_id__pd_print_standard__by__dbrid__get
  CREATE OR REPLACE FUNCTION TDMS.Dokument__pd_id__standard_pd_print__by__dbrid(
    IN  _dbrid varchar
    )
    RETURNS integer
    AS $$
    DECLARE
        _link_field varchar;
        _link_table varchar;
        _dok_id integer;
    BEGIN

        -- Gibt es ein Verlinktes Feld für die Suche?
        SELECT rck_column, rck_id
          INTO _link_field, _link_table
          FROM recnocommentkategorie
          JOIN picndoku ON pd_dbrid = _dbrid AND pd_tablename = rck_id
         WHERE rck_column IS NOT NULL;


        IF _link_field IS NULL THEN

            -- suche von Dokumenten, welche Direkt an diesem Datensatz hängen, keine weiteren Suchausdrücke vorhanden
            SELECT pd_id
              INTO _dok_id
              FROM picndoku
             WHERE pd_print
               AND NOT pd_deletable
               AND pd_dbrid = $1
             ORDER BY
                   pd_print DESC NULLS LAST,
                   pd_tablename = _link_table DESC,
                   pd_dokumentfile IS NOT NULL,
                   coalesce( pd_doktype, '' ) = 'zeichnung' DESC,
                   coalesce( pd_doktype, '' ) = 'q_messprot',
                   insert_date DESC,
                   coalesce( pd_path_user, pd_path )
            LIMIT 1;

            IF _dok_id IS NOT NULL THEN
                RETURN _dok_id;
            END IF;

            SELECT pd_id
              INTO _dok_id
              FROM picndoku
             WHERE pd_print
               AND NOT pd_deletable
               AND pd_id IN (
                      SELECT pdl_pd_id
                      FROM picndokulink
                      WHERE pdl_dbrid = $1
                   )
             ORDER BY
                   pd_print DESC NULLS LAST,
                   pd_tablename = _link_table DESC,
                   pd_dokumentfile IS NOT NULL,
                   coalesce( pd_doktype, '' ) = 'zeichnung' DESC,
                   coalesce( pd_doktype, '' ) = 'q_messprot',
                   insert_date DESC,
                   coalesce( pd_path_user, pd_path )
            LIMIT 1;

            RETURN _dok_id;

        ELSE

            -- wir suchen Dokumente, welche direkt angehangen sind ODER anhand des Schlagwortes,
            -- welches wir gefunden haben. zB art=Artikelnr. Es wird alles gesucht, was mit diesem
            -- Schlagwort vorhanden ist, nicht nur die Dokumente welche direkt an diesem Datensatz hängen
            EXECUTE
                'SELECT pd_id FROM picndoku ' ||
                'LEFT JOIN recnokeyword ON r_dbrid = picndoku.dbrid ' ||
                'WHERE pd_print AND NOT pd_deletable ' ||
                  '  AND ((pd_dbrid = $2))-- OR pd_id IN (SELECT pdl_pd_id FROM picndokulink WHERE pdl_dbrid = $2))' ||
                'ORDER BY pd_print DESC NULLS LAST, pd_tablename = $1 DESC, pd_dokumentfile IS NOT NULL, ' ||
                '  COALESCE(pd_doktype,'''')=''zeichnung'' DESC, COALESCE(pd_doktype,'''')=''q_messprot'', picndoku.insert_date DESC, COALESCE(pd_path_user, pd_path) ' ||
                'LIMIT 1; '
            USING _link_table, _dbrid
            INTO _dok_id;

            IF _dok_id IS NOT NULL THEN
              RETURN _dok_id;
            END IF;

            EXECUTE
                'SELECT pd_id FROM picndoku ' ||
                'LEFT JOIN recnokeyword ON r_dbrid = picndoku.dbrid ' ||
                'WHERE pd_print AND NOT pd_deletable ' ||
                  '  AND /*((pd_dbrid = $2))-- OR*/ pd_id IN ((SELECT pdl_pd_id FROM picndokulink WHERE pdl_dbrid = $2))' ||
                'ORDER BY pd_print DESC NULLS LAST, pd_tablename = $1 DESC, pd_dokumentfile IS NOT NULL, ' ||
                '  COALESCE(pd_doktype,'''')=''zeichnung'' DESC, COALESCE(pd_doktype,'''')=''q_messprot'', picndoku.insert_date DESC, COALESCE(pd_path_user, pd_path) ' ||
                'LIMIT 1; '
            USING _link_table, _dbrid
            INTO _dok_id;

            IF _dok_id IS NOT NULL THEN
                RETURN _dok_id;
            END IF;

            EXECUTE
                'SELECT pd_id FROM picndoku ' ||
                'LEFT JOIN recnokeyword ON r_dbrid = picndoku.dbrid ' ||
                'WHERE pd_print AND NOT pd_deletable ' ||
                '  AND /*OR*/ ((r_kategorie = $1 AND r_descr = (SELECT ' || quote_ident( _link_field ) || ' FROM ' || quote_ident( _link_table ) || ' WHERE dbrid = $2))) ' ||
                'ORDER BY pd_print DESC NULLS LAST, pd_tablename = $1 DESC, pd_dokumentfile IS NOT NULL, ' ||
                '  COALESCE(pd_doktype,'''')=''zeichnung'' DESC, COALESCE(pd_doktype,'''')=''q_messprot'', picndoku.insert_date DESC, COALESCE(pd_path_user, pd_path) ' ||
                'LIMIT 1; '
            USING _link_table, _dbrid
            INTO _dok_id;

            IF _dok_id IS NOT NULL THEN
                RETURN _dok_id;
            END IF;

        END IF;

        RETURN null;

    END$$ LANGUAGE plpgsql STABLE;



  --

  -- Letztes Dokument (ggf. nach Typ) an Datensatz bzw. Ident.
  --  z_99_deprecated.DMS_GetDokID
  CREATE OR REPLACE FUNCTION TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype(
    IN  _dbrid     varchar,
    IN  _doktype   varchar = '%',
    IN  _tablename varchar = null,
    IN  _dokident  varchar = null,
    IN  _ignore_dokident__fallback boolean = false --wenn Dokident NICHT gefunden, dann normale Suche über table/dbrid
    )
    RETURNS integer
    AS $$
    DECLARE
        _pdid integer;
    BEGIN


        IF
                _dokident IS null
            AND _dbrid IS null
        THEN

            RETURN null;
        END IF;

        -- Kein Ident angegeben
        IF _dokident IS NULL THEN

            -- https://redmine.prodat-sql.de/issues/9730  pd_dokident IS NULL
            -- dann auch nur, dokumente ohne dokident. wir gehen aktuell davon aus,
            -- das pdl_comment nur über dokident geschrieben wird und dokident somit einen
            -- wert hat an dem wir erkennen, das es ein dokument mit dokident ist,
            -- auch wenn dieser <> pdl_comment ist
            RETURN pd_id
              FROM picndoku LEFT JOIN picndokulink ON pd_id = pdl_pd_id
             WHERE pd_dbrid = _dbrid
               AND pd_doktype LIKE _doktype
               AND pd_tablename = coalesce( _tablename, pd_tablename )
               AND NOT pd_deletable
             ORDER BY pd_id DESC
             LIMIT 1;

        -- Ident angegeben, aber kein direkter Datensatz
        ELSE

            -- Bestelldokument Kunde: BDK hängt an auftgtxt, also an unterschiedlichen
            -- dbrid aber es gehört zu unterschiedlichen auftg, daher wird kein
            -- dbrid übergeben und nur über dokident gesucht
            -- => Auch Quatsch, es muss einfach die auftgtxt.dbrid übergeben werden alternativ. natürlich nicht die auftg.dbrid

            
            -- Debug: https://ci.prodat-sql.de/sources/tests/suite/16/runner/1188?selectedBranch=dev%2Fdsc%2F22904-lagzumobildms#teststep-21450
            SELECT pd_id
              INTO _pdid
              FROM picndoku LEFT JOIN picndokulink ON pd_id = pdl_pd_id
             WHERE pd_doktype LIKE _doktype
               AND pd_tablename = coalesce( _tablename, pd_tablename )
               AND (_dbrid IS null OR pd_dbrid = _dbrid)
               AND NOT pd_deletable
               AND (-- hier ist Dokident NIE null
                       pd_dokident = _dokident
                    OR pdl_comment = _dokident
                       -- es gibt überhaupt keine Einträge, dann wollen wir das letzte Passende.
                    OR (    -- es gab im ersten OR KEINEN Treffer
                        (    (pd_dokident IS null AND pdl_comment IS null)
                         OR  (_dokident NOT IN (pd_dokident, pdl_comment))
                        )
                            -- Fallback aktiv
                        AND _ignore_dokident__fallback
                        )
                   )
             ORDER BY 
                   (_dokident NOT IN (pd_dokident, pdl_comment)) IS false, -- Es gibt zu einer dbrid 2 Datensätze, einmal gefunden und einmal nicht sowie "_ignore_dokident__fallback", dann das direkt gefundene zuerst. zB mehrere Bilder Wareneingang zu einer Bestellung mit vielen Positionen
                   pd_id DESC
             LIMIT 1;

            IF _doktype IN ( 'bestblief', 'q_messprot' ) THEN

                RETURN coalesce(
                           (
                             -- Dokument über ld_abnr holen (bevorzugt wenn vorhanden)
                             SELECT pd_id
                               FROM ldsdok
                                    -- hier stehen wir in Besellung mit allen Dokumenten (ldsdoktxt.dbrid)
                               JOIN ldsdoktxt ON ldt_auftg = ld_auftg AND ldt_code = ld_code
                               JOIN picndoku ON pd_dbrid = ldsdoktxt.dbrid
                               JOIN recnokeyword ON r_tablename = 'picndoku' AND r_descr = ld_abnr AND r_dbrid = picndoku.dbrid
                              WHERE ld_id = _dokident
                                AND NOT pd_deletable
                              ORDER BY pd_id DESC
                              LIMIT 1
                           ),
                           _pdid
                       )
                ;

            ELSE

                RETURN _pdid;
            END IF;

        END IF;
        --
        RETURN null;

    END $$ LANGUAGE plpgsql STABLE;

  --



  -- DokID eines Dokuments mittels DokIdent und DokType (neustes Dokument)
  CREATE OR REPLACE FUNCTION TDMS.Dokument__pd_id__by__pd_dokident__pd_doktype(
    IN  _dokident varchar, -- kann null sein, dann muss dbrid einen Wert haben!
    IN  _doktype varchar,
    IN  _tablename varchar,
    IN  _dbrid varchar = null,
    IN  _ignore_dokident__fallback boolean = false --wenn Dokident NICHT gefunden, dann normale Suche über table/dbrid
    )
    RETURNS integer
    AS $$
    DECLARE
        _result integer;
    BEGIN
        IF (_dokident IS null AND _dbrid IS null)
           OR _tablename IS null
           OR _doktype IS null
        THEN
            RETURN null;
        END IF;

        -- dokident steht entweder in picndoku (bei 1:1) oder analog https://redmine.prodat-sql.de/issues/8429 in picndokulink > pdl_comment
        IF _dbrid IS NULL THEN

            -- TDMS.picndoku__dokuments__fetch_latest() geht nicht ohne _dbrid
            SELECT pd_id
              FROM picndoku
              LEFT JOIN picndokulink ON pd_id = pdl_pd_id
             WHERE pd_doktype = _doktype
               AND pd_tablename = _tablename
               AND NOT pd_deletable
               AND (   pd_dokident = _dokident
                    OR pdl_comment = _dokident
                    -- Fall back NICHT möglich, da kein _dbrid!
                   )
             ORDER BY pd_id DESC
             LIMIT 1
              INTO _result;

        ELSE
            -- TODO 18.02.2019 : SELECT durch neue Funktion ersetzen, damit Suche das selbe Ergebnis liefert, wie die Objektablage anzeigt.  https://redmine.prodat-sql.de/issues/9305
            SELECT pd_id
              FROM picndoku
              LEFT JOIN picndokulink ON pd_id = pdl_pd_id
             WHERE pd_doktype = _doktype
               AND pd_tablename = _tablename
               AND pd_dbrid = _dbrid
               AND NOT pd_deletable
               AND (   _dokident IS null
                    OR
                       pd_dokident = _dokident
                    OR pdl_comment = _dokident
                       -- es gibt überhaupt keine Einträge, dann wollen wir das letzte Passende.
                    OR (    -- es gab im ersten OR KEINEN Treffer
                        (    (pd_dokident IS null AND pdl_comment IS null)
                         OR  (_dokident NOT IN (pd_dokident, pdl_comment))
                        )
                            -- Fallback aktiv
                        AND _ignore_dokident__fallback
                        )
                   )
             ORDER BY pd_id DESC
             LIMIT 1
              INTO _result;

        END IF;

        RETURN _result;

    END $$ LANGUAGE plpgsql STABLE;

  --

  -- DokID eines Dokuments mittels DokIdent und einem/mehreren DokTypes (vom ersten gefundenen DokType das neuste Dokument)
  -- TDMS.dokument__pd_id__by__pd_dokident__pd_doktypes(ag_dokunr::varchar, tsystem.array__create__from__variadic('aufedok', 'auftg_dok'), 'auftgtxt', auftgtxt.dbrid) AS pdid,
  CREATE OR REPLACE FUNCTION TDMS.dokument__pd_id__by__pd_dokident__pd_doktypes(
    IN  _dokident   varchar,
    IN  _doktype    varchar[],
    IN  _tablename  varchar,
    IN  _dbrid      varchar = null,
    IN  _ignore_dokident__fallback boolean = false --wenn Dokident NICHT gefunden, dann normale Suche über table/dbrid
    )
    RETURNS integer
    AS $$
    DECLARE
        _did integer;
    BEGIN

        FOR i IN 1..array_upper( _doktype, 1 ) LOOP

            _did := TDMS.dokument__pd_id__by__pd_dokident__pd_doktype(
                              _dokident,
                              _doktype[ i ],
                              _tablename,
                              _dbrid,
                              _ignore_dokident__fallback
                              );

            IF _did IS NOT NULL THEN
                RETURN _did;
            END IF;

        END LOOP;

        RETURN null;

    END $$ LANGUAGE plpgsql STABLE;


  CREATE OR REPLACE FUNCTION TDMS.dokument__lifsch__pd_ids__by__w_wen(_w_wen integer) RETURNS SETOF integer
    AS $$

      SELECT pd_id 
        FROM recnokeyword 
        JOIN picndoku ON picndoku.dbrid = r_dbrid 
       WHERE r_kategorie = 'wendat' 
         AND r_descr = _w_wen 
         AND pd_doktype LIKE 'lifsch%' --IN ('lifsch', 'lifscha')
         AND NOT pd_deletable
       ORDER BY
             pd_id DESC

    $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;     


  CREATE OR REPLACE FUNCTION TDMS.dokument__lifsch__pd_id__by__w_wen(_w_wen integer) RETURNS integer
    AS $$

      SELECT TDMS.dokument__lifsch__pd_ids__by__w_wen(_w_wen) LIMIT 1

    $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;   

  CREATE OR REPLACE FUNCTION  TDMS.dokument__lifsch__exists__by__w_wen(_w_wen integer) RETURNS boolean
    AS $$

      SELECT TDMS.dokument__lifsch__pd_id__by__w_wen(_w_wen) IS NOT null;

    $$ LANGUAGE sql STABLE PARALLEL SAFE STRICT;




  CREATE OR REPLACE FUNCTION TDMS.dokument__lifsch__pd_ids__by__lfsnr__krz(_lfsnr varchar,  _ldkn varchar) RETURNS SETOF integer
    AS $$

      SELECT pd_id 
        FROM recnokeyword 
        JOIN picndoku ON picndoku.dbrid = r_dbrid 
       WHERE -- Keyword Lieferscheinnummer UND Adresse
             r_kategorie IN ('lifsch', 'ad_krz')
         AND r_descr     IN (_lfsnr, _ldkn)
             -- picndoku
         AND pd_doktype LIKE 'lifsch%' --IN ('lifsch', 'lifscha')
         AND NOT pd_deletable
       ORDER BY
             pd_id DESC

    $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;     


  CREATE OR REPLACE FUNCTION TDMS.dokument__lifsch__pd_id__by__lfsnr__krz(_lfsnr varchar,  _ldkn varchar) RETURNS integer
    AS $$

      SELECT TDMS.dokument__lifsch__pd_ids__by__lfsnr__krz(_lfsnr, _ldkn)  LIMIT 1

    $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;     

  -- Verschlagwortet Dokumente neu.
  --  Aktuell nur Dummy/Wrapper für Trigger, welche UPDATE picndoku macht. Löst wieder Trigger aus. Sollte mal zukünftig sinnvolle Verschlagwortung ohne Triggerkaskade geben. Dann ist diese Funktion aber erst recht sinnvoll
  CREATE OR REPLACE FUNCTION TDMS.dokument__keywords__update__by__pd_dbrid_dokident_doktype(
       IN _dbrid     varchar,
       IN _doktype   varchar = '%',
       IN _tablename varchar = null,
       IN _dokident  varchar = null
       )
       RETURNS bool
       AS $$
       BEGIN
           -- Aktualisiert das gefundene Dokument
           -- TODO Anpassung? Alle Dokumente? pd_ids? => Überlegung: letztes Bestellbestätigungsdokument, oder alle? Aktuell nur das letzte.
           UPDATE picndoku
              SET pd_id = pd_id
            WHERE pd_id = TDMS.dokument__pd_id__by__pd_dbrid__pd_doktype(
                                    _dbrid,
                                    _doktype,
                                    _tablename,
                                    _dokident
                                    );

           RETURN found;
       END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION TDMS.dokument__keywords__update__by__pd_dokident_doktype(
       IN _dokident  varchar,
       IN _doktype   varchar = '%',
       IN _tablename varchar = null,
       IN _dbrid     varchar = null
       )
       RETURNS bool
       AS $$
       BEGIN
           -- Aktualisiert das gefundene Dokument
           -- TODO Anpassung? Alle Dokumente? pd_ids? => Überlegung: letztes Bestellbestätigungsdokument, oder alle? Aktuell nur das letzte.
           UPDATE picndoku
              SET pd_id = pd_id
            WHERE pd_id = TDMS.dokument__pd_id__by__pd_dokident__pd_doktype(
                                    _dokident,
                                    _doktype,
                                    _tablename,
                                    _dbrid
                                    );

           RETURN found;
       END $$ LANGUAGE plpgsql;

-- ########################################################

-- ##################################### Dokumentbaum (dokutreenodes)
  -- SELECT tsystem.function__drop_by_regex('Dokumentbaum__dtn_nodeids__childs__by__dtn_nodeid', 'TDMS', true, true);
  -- ACHTUNG: StandardSQL: QS.TFormWEKBericht.ServSQLDokumente. Alle Dokumente, außer ungültige Zeichnungen #15444 #16069
  CREATE OR REPLACE FUNCTION TDMS.Dokumentbaum_tree__dtn_nodeids__childs__by__dtn_nodeid__get(
        VARIADIC _dtn_nodeid      integer[],

        OUT dtn_nodeid            integer,
        OUT dtn_caption           varchar,
        OUT level                 integer,
        OUT dtn_nodeid__parent    integer,
        OUT dtn_id                integer
    )
    RETURNS SETOF record
    AS $$

        WITH RECURSIVE
          _tree AS (
              SELECT dtn_id,
                     dtn_nodeid,
                     dtn_caption,
                     1 AS level,
                     null::int AS parent
                FROM dokutreenodes
               WHERE dtn_nodeid = any( _dtn_nodeid )
            UNION ALL
              SELECT child.dtn_id,
                     child.dtn_nodeid,
                     child.dtn_caption,
                     _tree.level + 1,
                     parent.dtn_nodeid AS parent_nodeid
                FROM dokutreenodes child
                JOIN dokutreenodes parent ON parent.dtn_id = child.dtn_parentid
                JOIN _tree ON child.dtn_parentid = _tree.dtn_id
          )
          SELECT dtn_nodeid, dtn_caption, level, parent, dtn_id
          FROM _tree

    $$ LANGUAGE sql;



--

-- ##################################### EXTERNES DMS (ELO)

  -- Zugriffsfunktionen für externes DMS - z.B. ELO / DMS-SYNC-USER    https://redmine.prodat-sql.de/issues/9153 https://redmine.prodat-sql.de/issues/9145
  /* https://redmine.prodat-sql.de/projects/prodat-v12-public/wiki/ELO
     Beispiele:
      SELECT * FROM TDMS.External_DMS__get_Documents;                -- "geänderte" Dokumente auslesen ...
      SELECT * FROM TDMS.External_DMS__get_Documents WHERE is_updated_or_new;
      SELECT * FROM TDMS.External_DMS__get_Documents WHERE is_updated_or_new AND pd_external_dms_id IS NOT NULL;
      SELECT * FROM TDMS.External_DMS__get_Documents WHERE pd_external_dms_id = "external_id";
      SELECT TDMS.External_DMS__set_ID(pd_id, "external_id");        -- externe ID speichern
      SELECT TDMS.External_DMS__reset_Updated(pd_id);                -- Änderungsstatus zurücksetzen
      SELECT * FROM TDMS.External_DMS__get_Keywords(pd_id);          -- Schlüsselworte auslesen
      SELECT TDMS.External_DMS__get_RemoteFilename(pd_id, True);     -- "internen" Dateinamen auslesen (siehe auch TDMS.External_DMS__get_Documents)
  */

  -- für externes DMS: Liste der Schlagworte eines Dokumentes
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__get_Keywords(pdid integer, OUT r_kategorie varchar(30), OUT r_descr varchar(100))
      RETURNS SETOF record
      AS $$
          SELECT r_kategorie, r_descr
            FROM picndoku
            JOIN recnokeyword ON r_tablename = 'picndoku'
             AND r_dbrid = picndoku.dbrid
             AND r_descr IS NOT NULL
            --AND NOT r_kategorie IN ('', '', ...)
           WHERE pd_id = pdid
           ORDER BY 1, 2
      $$ LANGUAGE sql STABLE;
  --

  /*-- für externes DMS: Schlagwort eines Dokumentes ändern
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__set_Keyword(pdid integer, kategorie varchar, descr varchar)
    RETURNS VOID AS $$
    BEGIN
      PERFORM CreateRecNoKeyword(kategorie, descr, dbrid)  --DeleteRecNoKeyword(kategorie, descr, dbrid)
      WHERE pd_id = pdid;
    END $$ LANGUAGE plpgsql;
  --*/

  -- für externes DMS: Pfad eines Dokuments, aus Sicht unseres Application-Servers
  -- Abgespeckte Kopie der Funktion TDokument.DMSRemoteFilename, ohne Parameter um einen neuen Pfad zu generieren
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__get_RemoteFilename(pdid integer, inclLinked BOOLEAN DEFAULT False)
      RETURNS varchar
      AS $$
      DECLARE PD           record;   -- picndoku(d_id)
      --DECLARE Result     varchar;  -- TDokument.DMSRemoteFilename
              DefaultPath  varchar;  -- TDokument.DMSStandardPath
              ArchiveIdent varchar;  -- TDokument.DMSArchiveIdent
              ArchivePath  varchar;  -- TDokument.DMSArchivePath
      BEGIN
        SELECT * INTO PD FROM picndoku WHERE pd_id = pdid;
        IF PD.pd_dmsremotefile IS NULL THEN  -- TDokument.isDMSDokument
          IF inclLinked THEN
            RETURN PD.pd_dokumentfile;
          ELSE
            RETURN NULL;
          END IF;
        ELSE
          DefaultPath  := TSystem.Settings__Get('DMSStandardPath');
          ArchiveIdent := IfThen(PD.pd_archive, dt_da_name_archive, dt_da_name) FROM dokutypes WHERE dt_id = coalesce(PD.pd_dmsremotefiledoktype, PD.pd_doktype);
          ArchivePath  := Trim(TRAILING E'\\' FROM Coalesce(NullIf((SELECT da_path FROM dokuarchiv WHERE da_name = ArchiveIdent), ''), DefaultPath))
            || E'\\' || to_char(PD.pd_stamp, 'YYYY') || E'\\' || to_char(PD.pd_stamp, 'MM') || E'\\' || coalesce(PD.pd_dmsremotefiledoktype, 'unknown') || E'\\';
          RETURN ArchivePath || PD.pd_dmsremotefile;
        END IF;
      END $$ LANGUAGE plpgsql STABLE;
  --

  -- für externes DMS: externe ID bei uns speichern
  -- ACHTUNG: nur im Kontext des DMS-Users ausführen (z.B. 'ELO')
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__set_ID(pdid integer, external_dms_id varchar, OUT result boolean)
      RETURNS boolean
      AS $$
      DECLARE
        tabname varchar;
        dokfile varchar;
      BEGIN
        --- #17067
        --- ASSERT current_user IN ('ELO', 'DMS-SYNC-USER'), 'FUNCTION External_DMS__set_ID: invalid login';
        ASSERT NOT TSystem.dms__notify__changes(), 'FUNCTION External_DMS__set_ID: invalid login';

        IF NOT EXISTS( SELECT 1 FROM picndoku WHERE pd_id = pdid ) THEN
          RAISE EXCEPTION 'Ungültiges Bild xtt17106 %', pdid;
        END IF;

        -- #20526 Absicherung gegen doppelte IDs
        IF EXISTS( SELECT 1 FROM picndoku WHERE pd_external_dms_id = external_dms_id ) THEN
          RAISE EXCEPTION 'Doppelte externe ID xtt28689 %', external_dms_id;
        END IF;

        SELECT pd_tablename, trim( pd_dokumentfile ) INTO tabname, dokfile FROM picndoku WHERE pd_id = pdid;

        IF tabname = 'dokseals' THEN
          RAISE EXCEPTION 'Bild gesperrt xtt28690 %', pdid;
        END IF;

        IF coalesce( dokfile, '' ) = '' THEN   -- custom folders
          RAISE EXCEPTION 'Bilddatei fehlt xtt28691 %', pdid;
        END IF;

        UPDATE picndoku
        SET pd_external_dms_id = external_dms_id
        WHERE pd_id = pdid;

        result := FOUND;

      END $$ LANGUAGE plpgsql;
  --

  -- für externes DMS: Nach übernommenen Änderungen den Änderungsstatus zurücksetzen
  -- ACHTUNG: nur im Kontext des DMS-Users ausführen (z.B. 'ELO')
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__reset_Updated(pdid integer, OUT result boolean)
      RETURNS boolean AS $$
      BEGIN
        --- #17067
        --- ASSERT current_user IN ('ELO', 'DMS-SYNC-USER'), 'FUNCTION External_DMS__reset_Updated: invalid login';
        ASSERT NOT TSystem.dms__notify__changes(), 'FUNCTION External_DMS__reset_Updated: invalid login';
        UPDATE picndoku
        SET pd_external_dms_updated = NULL, pd_external_dms_changed = NULL
        WHERE pd_id = pdid
        RETURNING pd_id IS NOT NULL INTO result;
        RETURN;
      END $$ LANGUAGE plpgsql;
  --

  CREATE OR REPLACE FUNCTION TDMS.view__External_DMS__get_Documents__recreate() RETURNS VOID AS $$
      BEGIN
        -- für externes DMS: Liste aller "geänderten" Dokumente (Aufruf-Beispiele siehe oben)
        CREATE OR REPLACE VIEW TDMS.External_DMS__get_Documents AS
          SELECT
            pd_external_dms_id,                                                                        -- document ID in external DMS
            TSystem.IfThen(pd_external_dms_id NOTNULL, pd_external_dms_updated, COALESCE(pd_external_dms_updated, pd_modified, pd_date::TIMESTAMP)) AS pd_external_dms_updated,  -- last changed at
            TSystem.IfThen(pd_external_dms_id NOTNULL, pd_external_dms_changed, concat_ws(',', 'file', TSystem.IfThen(pd_dmscomment, 'annotation', NULL),
              'recinfo', TSystem.IfThen(exists(SELECT TDMS.External_DMS__get_Keywords(picndoku.pd_id)), 'keyword', NULL)))::varchar(50) AS pd_external_dms_changed,              -- what has changed (file, annotation, recinfo, keyword)
            (pd_external_dms_updated IS NOT NULL OR pd_external_dms_id IS NULL) AS is_updated_or_new,  -- .
            pd_dmsremotefile IS NULL AS is_linked,                                                     -- document is linked
            TDMS.External_DMS__get_RemoteFilename(picndoku.pd_id, True) AS pd_dmsremotefile,           -- internal file name

            rc.pd_revision_id,                           -- revision (related documents with the same ID)
            rc.pd_revision_count,                        -- count of revisions
            rc.pd_revision_pos,                          -- position in revisions
            ri.pd_revision_pdids,                        -- list of all pd_id in revisions
            pd_deletable,                                -- hidden / deleted (e.g. older revision)
            pd_dmscomment,                               -- has comment/stamp/annotaions on file

            picndoku.pd_id,                              -- document ID in PRODAT
            COALESCE(pd_path_user, pd_path) as pd_path,  -- caption
            pd_txt,                                      -- comment
            pd_doktype,                                  -- document type (classification)
            COALESCE(dt_external_dms_dokutype, pd_doktype) AS pd_external_doktype,    -- alternating document type for external DMS
            pd_tablename, pd_dbrid, pd_dokident,         -- owner
            pd_source,                                   -- file origin (print, scan, file, camera, bi, image, ...)
            pd_date,                                     -- date of printing or import
            pd_modified                                  -- modified date
          FROM picndoku
          LEFT JOIN dokutypes ON pd_doktype = dt_id
          LEFT JOIN (SELECT pd_id, pd_revision_id, count(*) OVER (PARTITION BY pd_revision_id) AS pd_revision_count,
              row_number() OVER (PARTITION BY pd_revision_id ORDER BY pd_id NULLS LAST) AS pd_revision_pos
            FROM picndoku WHERE pd_revision_id IS NOT NULL) AS rc ON rc.pd_id = picndoku.pd_id AND rc.pd_revision_count > 1
          LEFT JOIN (SELECT pd_revision_id, string_agg(pd_id::varchar, ',' ORDER BY pd_id) AS pd_revision_pdids, count(*) AS pd_revision_count
            FROM picndoku WHERE pd_revision_id IS NOT NULL GROUP BY pd_revision_id) AS ri ON ri.pd_revision_id = picndoku.pd_revision_id AND ri.pd_revision_count > 1
          WHERE pd_dokumentfile IS NOT NULL              -- custom folders
            AND pd_tablename <> 'dokseals'               -- seal images
            AND (dt_external_dms_dokutype IS NOT NULL OR pd_external_dms_id IS NOT NULL)  -- only shared document types or what was released once
          ORDER BY pd_external_dms_id ISNULL, picndoku.pd_id; --ORDER BY pd_external_dms_id NULLS LAST, pd_external_dms_updated;
        --
      END $$ LANGUAGE plpgsql;
  --

  --
  CREATE OR REPLACE FUNCTION TDMS.External_DMS__adk(adkrz varchar, OUT a1_knr integer, OUT a2_knr integer, OUT ad_such varchar(75), OUT adressename varchar(150))
      AS $$
      BEGIN
          -- #10747 - in Adressen und abweichenden Adressen suchen: ACHTUNG! Es wird immer nur der erste Datensatz zurückgegeben, falls beide gefunden.
          SELECT sub.a1_knr, sub.a2_knr, sub.ad_such, adressename(sub.ad_krz) INTO a1_knr, a2_knr, ad_such, adressename FROM
            (SELECT adk1.a1_knr, adk2.a2_knr, adk.ad_such, ad_krz
             FROM adk
               LEFT JOIN adk1 ON a1_krz = ad_krz
               LEFT JOIN adk2 ON a2_krz = ad_krz
             WHERE ad_krz = adkrz

             UNION
             SELECT adk1.a1_knr, adk2.a2_knr, adk.ad_such, ada_krzl AS ad_krz   -- wenn adkrz in adk nicht gefunden, dann in abweichenden Adressen suchen
             FROM adk_adresses ada
               JOIN adk ON ada_ad_krz = ad_krz
               LEFT JOIN adk1 ON a1_krz = ad_krz
               LEFT JOIN adk2 ON a2_krz = ad_krz
             WHERE ada_krzl = adkrz
            ) sub
          WHERE sub.ad_krz = adkrz;
          /*
          SELECT adk1.a1_knr, adk2.a2_knr, adk.ad_such, adressename(ad_krz) INTO a1_knr, a2_knr, ad_such, adressename
            FROM adk LEFT JOIN adk1 ON a1_krz = ad_krz LEFT JOIN adk2 ON a2_krz = ad_krz WHERE ad_krz = adkrz;
          */
          RETURN;
      END $$ LANGUAGE plpgsql;
  --

  -- Holt Hauptadresskürzel zu dokument
  CREATE OR REPLACE FUNCTION TDMS.picndoku__fetch__metadata(
      IN search_for_pd_id integer,
      OUT metadata jsonb
      )
      AS $$
      DECLARE docdata record;
              tmp record;
      BEGIN
          metadata := '{}'::jsonb;

          tmp := row(null);

          -- SELECT pd_dbrid, pd_tablename INTO data FROM TDMS.external_dms__get_documents as view WHERE pd_id =  search_for_pd_id;

          -- ref_dbrid := data.pd_dbrid;
          -- ref_tablename := data.pd_tablename;

          -- RAISE NOTICE 'dbrid: %, tablename: %', ref_dbrid, ref_tablename;

          SELECT pd_doktype,pd_dokident,insert_by INTO docdata FROM picndoku WHERE pd_id = search_for_pd_id;

          -- RAISE NOTICE 'doctype: %', docdata;

          -- Auftragsbestätigungen / Angebote
          IF docdata.pd_doktype IN ('aufedok','aufadok') THEN
          SELECT
            ag_lkn AS adkrz,
            ag_nr AS auftxt,
            ag_bda AS auf_bda
            INTO tmp
          FROM auftg
          WHERE auftg.ag_dokunr = docdata.pd_dokident
          ORDER BY ag_pos
          LIMIT 1;
          END IF;

          -- Lieferschein (Verkauf)
          IF docdata.pd_doktype IN ('lfs') THEN
          SELECT
              COALESCE(ag_lkn, beld_krzlieferung) AS adkrz,
              ag_nr AS auftxt,
              ag_bda AS auf_bda
              INTO tmp
          FROM Lieferschein AS lief
          JOIN Lieferschein_pos AS lp ON ( lp.belp_dokument_id = lief.beld_id )
          LEFT JOIN lifsch AS l ON ( l.l_belp_id = lp.belp_id ) --voränger
          LEFT JOIN auftg AS a ON ( a.ag_id = COALESCE(l.l_ag_id, lp.belp_ag_id) )
          WHERE lief.beld_dokunr  = docdata.pd_dokident
          ORDER BY lp.belp_pos
          LIMIT 1;
          END IF;

          -- Lieferschein Beistellung Lieferant (Einkauf)
          IF docdata.pd_doktype IN ('lfslds_be') THEN -- #9896 Änderung von 'lfsbe'
          SELECT
            lief.beld_krzlieferung AS adkrz,
            d.ld_auftg AS ldsdoktxt
            INTO tmp
          FROM  Lieferschein AS lief
          INNER JOIN Lieferschein_pos AS lp ON ( lp.belp_dokument_id = lief.beld_id )
          INNER JOIN lifsch AS l ON l.l_belp_id = lp.belp_id
          LEFT JOIN abk AS a ON a.ab_ix = l.l_ab_ix
          LEFT JOIN ldsdok AS d ON d.dbrid=a.ab_dbrid
          WHERE lief.beld_dokunr  = docdata.pd_dokident
          ORDER BY lp.belp_pos
          LIMIT 1;
          END IF;

          -- Retourenlieferschein (an Lieferant, Einkauf) -- #9896
          IF docdata.pd_doktype IN ('lfslds_rk') THEN
          SELECT
            lief.beld_krzlieferung AS adkrz,
            d.ld_auftg AS ldsdoktxt
            INTO tmp
          FROM  Lieferschein AS lief
          INNER JOIN Lieferschein_pos AS lp ON ( lp.belp_dokument_id = lief.beld_id )
          INNER JOIN lifsch AS l ON l.l_belp_id = lp.belp_id
          LEFT JOIN ldsdok d ON d.ld_id = l.l_ld_id  -- Ausgangsbestellung zur Reklamation
          WHERE lief.beld_dokunr  = docdata.pd_dokident
          ORDER BY lp.belp_pos
          LIMIT 1;
          END IF;

          -- Bestellung Lieferant
          IF docdata.pd_doktype IN ('ldsdok_bestdok') THEN
          SELECT
            ld_kn AS adkrz,
            ld_auftg AS ldsdoktxt
            INTO tmp
          FROM ldsdok
          WHERE ldsdok.ld_dokunr = docdata.pd_dokident
          ORDER BY ld_pos
          LIMIT 1;
          END IF;

          -- Ausgangsrechnung -- #22371: Ergänzung be_bdat
          IF docdata.pd_doktype IN ('rechnung') THEN
          SELECT
            be_rkrz AS adkrz,
            be_bdat AS be_bdat
            INTO tmp
          FROM belkopf
          WHERE belkopf.be_bnr = docdata.pd_dokident;
          END IF;

          -- ci testing

          --IF tmp IS NOT NULL THEN -- !!ACHTUNG! bei "IS NOT NULL" darf kein Wert NULL sein!! #10746
          IF tmp IS NULL THEN     --            bei "IS NULL" dagegen müssen alle Werte NULL sein..
            -- keine Daten vorhanden
          ELSE
            --
            metadata := row_to_json( tmp );
            metadata := metadata || jsonb_build_object('picndoku__insert_by',docdata.insert_by);
          END IF;

      END $$ LANGUAGE plpgsql;
  --

  SELECT TDMS.view__External_DMS__get_Documents__recreate();

  -- TestSelects
  -- SELECT TDMS.picndoku__fetch__metadata(1110); -- aufedok
  -- SELECT TDMS.picndoku__fetch__metadata(1112); -- ldsdok_bestdok
  -- SELECT TDMS.picndoku__fetch__metadata(1119); -- lfslds_be
  -- SELECT TDMS.picndoku__fetch__metadata(1114); -- lfs
  -- SELECT TDMS.picndoku__fetch__metadata(1116); -- rechnung

  -- Dokumente für Objektablage   https://redmine.prodat-sql.de/issues/9305
  CREATE OR REPLACE FUNCTION TDMS.picndoku__dokuments__fetch_latest(
    IN _source_table varchar, -- OR KATEGORIE Schlagwort!
    IN _source_dbrid varchar,
    IN _recno_keyword varchar = NULL,
    IN _filter_to_doktype varchar = NULL, -- ENUM!
    IN _exclude_deleted BOOL = True,
    IN _only_is_print BOOL = False,
    IN _limit INT = NULL
    )
    RETURNS SETOF INT
    AS $$
    DECLARE
      _default_doktype_on_null CONSTANT varchar := 'sonstiges';
    BEGIN

      -- solange dms nicht angepasst ist _limit = 35 als neues null zu betrachten
      -- eventl. kann der parameter komplett entfernt werden
      IF ( _limit = 35 ) THEN
        _limit := null;
      END IF;

      IF _source_table IS NULL THEN
        _source_table := pd_tablename FROM picndoku WHERE pd_dbrid = _source_dbrid LIMIT 1;
      END IF;

      RETURN QUERY
        WITH
          _data_plain AS (
            SELECT pd_id, pd_doktype, pd_dokumentfile, pd_deletable, pd_print, picndoku.insert_date
              FROM picndoku
              LEFT JOIN dokutypes ON dt_id = pd_doktype
              WHERE pd_tablename = _source_table AND pd_dbrid = _source_dbrid
          ),
          _data_link AS (
            SELECT pd_id, pd_doktype, pd_dokumentfile, pd_deletable, pd_print, picndoku.insert_date
              FROM picndoku
              LEFT JOIN dokutypes    ON dt_id = pd_doktype
             INNER JOIN picndokulink ON pd_id = pdl_pd_id
             WHERE pdl_tablename = _source_table AND pdl_dbrid = _source_dbrid
          ),
          _data_recno AS (
            SELECT pd_id, pd_doktype, pd_dokumentfile, pd_deletable, pd_print, picndoku.insert_date
              FROM picndoku
              LEFT JOIN dokutypes    ON dt_id = pd_doktype
             INNER JOIN recnokeyword ON r_dbrid = picndoku.dbrid --AND r_tablename = 'picndoku'
             WHERE _recno_keyword IS NOT NULL AND r_kategorie = _source_table AND r_descr = _recno_keyword
          ),

          _data_sum AS (
            SELECT * FROM _data_plain
            UNION
            SELECT * FROM _data_link
            UNION
            SELECT * FROM _data_recno
          ),

          _data_ranked AS (
            SELECT *, row_number() OVER (PARTITION BY pd_doktype ORDER BY insert_date DESC) AS num
              FROM _data_sum
             WHERE CASE WHEN _exclude_deleted
                        THEN pd_deletable = NOT _exclude_deleted
                   ELSE true
                   END
              AND  -- NOT (pd_deletable AND _exclude_deleted)
                   CASE WHEN _only_is_print
                        THEN pd_print = _only_is_print
                   ELSE true
                   END
              AND            -- AND (pd_print OR NOT _only_is_print)
                   CASE WHEN _filter_to_doktype IS NOT NULL
                        THEN TSystem.ENUM_ContainsValue(coalesce(pd_doktype, _default_doktype_on_null), _filter_to_doktype)
                   ELSE true
                   END          -- AND (_filter_to_doktype IS NULL OR pd_doktype = _filter_to_doktype)
          )
        SELECT pd_id
          FROM _data_ranked
         WHERE
                (
                  -- default limit aus den dokutypes wird im funktionsaufruf überschrieben
                  _limit IS NOT NULL and num <= _limit
                  OR
                  -- default kommt aus der dokutypes tabelle
                  _limit IS NULL AND num <= ( SELECT dt_display_limit FROM dokutypes WHERE dt_id = coalesce(_data_ranked.pd_doktype, _default_doktype_on_null) )
                )
                                                                   -- Limit pro Dokumenttyp
                OR pd_print IS NOT DISTINCT FROM True                             -- StandardDokumente (vor allem das am eigenen Datensatz source_table+source_dbrid)

                 -- das sollte nicht hier drin sein, die ordner sollten ausserhalb der funktion geholt werden.
                OR (pd_dokumentfile IS NULL AND NOT _only_is_print)               --   und CustomFolder (außer wenn nur Standarddokumente) immer ausgeben, egal wie alt sie sind

                 -- sonstiges hinten anstellen
         ORDER BY coalesce( _default_doktype_on_null, pd_doktype ) = _default_doktype_on_null
      ;

      -- Im Fall QAB auch die Artikeldaten anzeigen
      IF _source_table = 'qab' THEN
        RETURN QUERY SELECT TDMS.picndoku__dokuments__fetch_latest('art', null, _recno_keyword => q_ak_nr, _filter_to_doktype => 'quality_messzn,zeichnung') FROM qab  WHERE q_nr = _recno_keyword; -- https://redmine.prodat-sql.de/issues/22289
      END IF;
      -- Im Fall ABK auch die Artikeldaten anzeigen
      IF _source_table = 'abk' THEN
        RETURN QUERY SELECT TDMS.picndoku__dokuments__fetch_latest('art', null, _recno_keyword => ab_ap_nr, _filter_to_doktype => 'quality_messzn,zeichnung') FROM abk WHERE ab_ix = _recno_keyword; -- https://redmine.prodat-sql.de/issues/22289
      END IF;
      RETURN;

    END $$ LANGUAGE plpgsql;



-- #21867 Funktion für die Ermittlung der Zusatzdokumente beim Ausdruck von Einkaufsdokumenten (Bestellung, Bestellung Auswärts, Anfrage an Lieferant)
CREATE OR REPLACE FUNCTION tdms.reporting__attachements__einkauf__stv__get(
  IN _ld_dokunr integer,
  IN _anf_nr varchar,
  IN _bg_aufloesen boolean = false
  )
  RETURNS TABLE(
    pd_id integer,
    position_identpos integer,
    sortid integer,
    pd_path varchar
  )
  AS $$
  BEGIN

      RETURN QUERY
      SELECT DISTINCT picndoku.pd_id, sub.position_identpos, sub.sortid::integer, picndoku.pd_path
      FROM (
        SELECT
          row_number() OVER (PARTITION BY dokument_positionen.position_identpos) AS SortID, -- Sortierung der Stücklistenauflösung innerhalb der Dokumentpositionen ACHTUNG BIGINT
          COALESCE(stueckl__do_stueckl_list.stn, dokument_positionen.artikelnummer) AS stn, -- Artikel aus Stücklistenauflösung oder des Dokuments
          stueckl__do_stueckl_list.ebene,
          dokument_positionen.position_identpos -- Dokumentposition
        FROM (
        -- je nach Dokument die Dokumentpositionen sammeln.
        -- Muss erneut auf ReportingViews gehen, da Statement nicht dynamisch pro Position ausgeführt wird, sonder 1mal am Ende

          -- Bestellpositionen aus entspr. View
          SELECT
            ldsdok_beleg_positionen.position_identpos,
            ldsdok_beleg_positionen.artikelnummer,
            ldsdok_beleg_positionen.menge
          FROM treporting.ldsdok_beleg_positionen
          WHERE ldsdok_beleg_positionen.position_dokument_id = _ld_dokunr
          --

          UNION

          -- Anfragepositionen aus entspr. View
          SELECT
            anfrage_anfart_positionen.position_identpos,
            anfrage_anfart_positionen.artikelnummer,
            anfrage_anfart_positionen.menge
          FROM treporting.anfrage_anfart_positionen
          WHERE anfrage_anfart_positionen.position_identnummer = _anf_nr
          --

        ) AS dokument_positionen
          -- Stücklistenauflösung der Artikel im Dokument, wenn Option Baugruppen auflösen aktiv (Performance)
          -- Ansonsten nur Artikel des Dokuments
          LEFT JOIN LATERAL tartikel.stueckl__do_stueckl_list(artikelnummer, artikelnummer, menge) ON _bg_aufloesen
      ) AS sub
        JOIN art ON ak_nr = stn
        JOIN picndoku ON pd_tablename = 'art' AND pd_dbrid = art.dbrid -- Dokumente der Artikel
        LEFT JOIN dokutypes ON dt_id = pd_doktype
      WHERE (   COALESCE(pd_parentnodeident, dt_parentnodeid) IN (15, 17) -- direkt im Ordner Zeichnungen und Stücklisten hinterlegt, oder Ordner per Dokumenttyp definiert
           -- optionale Bedingungen:
           OR pd_doktype IN ('zeichnung','zeichnung_auswaerts') -- Einschränkung auf Dokumenttyp
           )
           AND (pd_parentnodeident IS null OR NOT ( pd_parentnodeident IN (21,18,16) )) -- ungültige Versionen (Ordner)
        -- AND ebene = 0 -- nur 1. Ebene
      ORDER BY sub.position_identpos, sub.SortID::integer, picndoku.pd_path, picndoku.pd_id;

  END $$ LANGUAGE plpgsql STABLE;



-- #20821, #22738 ermittelt alle pd_ids der Chargenzeugnisse zu einem bestimmten Lieferschein
-- Parameter _via_pa (derzeit nicht benutzt): Kann man hier über den Produktionsauftrag gehen oder muss man die Lagerbewegungen bemühen?
CREATE OR REPLACE FUNCTION tdms.reporting__attachements__pd_id__chargenzeugnisse__beld_dokunr__get(
  IN _beld_dokunr varchar,
  IN _via_ldsdok__ld_auftg__pa boolean = tsystem.settings__getbool( 'reporting__lifsch__matzeugnis__by__auftragsnummer' )
  )
  RETURNS SETOF integer AS $$
  DECLARE
    abks integer[];
  BEGIN
  
    IF tsystem.settings__getbool( 'reporting__lifsch__matzeugnis__attach' ) THEN
    -- Liefert nur Ergebnisse, wenn Kunde mit Chargenzeugnissen arbeitet.
  
      IF _via_ldsdok__ld_auftg__pa THEN
      -- Wenn Parameter gesetzt, dann zugehörige ABKs über den Produktionsauftrag suchen.
  
          abks := array_agg( abix )
        FROM abk
        CROSS JOIN LATERAL tplanterm.get_all_child_abk( ab_ix ) AS abix
          JOIN ldsdok ON ld_id = ab_ld_id
          JOIN auftg ON ag_id = ld_ag_id
          JOIN belegpos ON belp_ag_id = ag_id
          JOIN belegdokument ON belp_dokument_id = beld_id
          WHERE beld_dokunr = _beld_dokunr;
      ELSE
      -- Wenn Parameter nicht gesetzt, dann zugehörige ABKs über die Lagerzugänge suchen.
  
          abks := array_agg( ab_ix )
          FROM abk
          JOIN wendat ON w_ab_ix = ab_ix
          JOIN lifsch ON l_w_wen = w_wen
          JOIN auftg ON ag_id = l_ag_id
          JOIN belegpos ON belp_ag_id = ag_id
          JOIN belegdokument ON belp_dokument_id = beld_id
          WHERE beld_dokunr = _beld_dokunr;
      END IF;
  
      IF abks IS NOT null THEN
      -- Wurden ABKs gefunden (auf dem einen oder anderen Weg), dann alle Chargenzeugnisse,
      -- welche mit einer der ABKs verschlagwortet ist, zurückgeben.
  
        RETURN QUERY
        SELECT pd_id FROM picndoku
        JOIN recnokeyword ON
              r_tablename = 'picndoku'
          AND r_kategorie = 'abk'
          AND r_descr = ANY( abks )
          AND r_dbrid = picndoku.dbrid
        WHERE pd_doktype IN ('quality_we', 'quality_weaw');
      ELSE
      -- Keine ABKs gefunden? Dann wird von einem Kaufteil ausgegangen, welches ohne Fertigung ausgeliefert wird.
      -- Dann die dierekt meit dem Lagerzugang verknüften Zeugnisse zurückgeben.
  
        RETURN QUERY
        SELECT pd_id FROM picndoku
        JOIN recnokeyword ON
              r_tablename = 'picndoku'
          AND r_kategorie = 'wendat'
          AND r_dbrid = picndoku.dbrid
        JOIN wendat ON w_wen::varchar = r_descr
        JOIN lifsch ON l_w_wen = w_wen
        JOIN auftg ON ag_id = l_ag_id
        JOIN belegpos ON belp_ag_id = ag_id
        JOIN belegdokument ON belp_dokument_id = beld_id AND beld_dokunr = _beld_dokunr
        WHERE pd_doktype IN ('quality_we', 'quality_weaw');
      END IF;
    END IF;
  
  END $$ LANGUAGE plpgsql STABLE;
--
--
